//Performance comparison of Simulated BER and Theoritical BER of BPSK and QPSK modulation over AWGN channel
clc;
clear;
xdel(winsid());
sym=10000;//No .of symbols
M=4;
qpsk_mod=[];i_phase=[];
data1=grand(1,sym,"uin",0,1);//Random Symbol generation from 0 to 1 with uniform distribution
for j=1:2:length(data1)// Seperation of I & Q component
   i_phase=2*data1(j)-1;// BPSK modulation of I phase component
   q_phase=2*data1(j+1)-1;//BPSK modulation of Q phase component
   temp=i_phase+%i*q_phase;//combining of I phase and Q phase component for QPSK modulation
   qpsk_mod=[qpsk_mod temp];//QPSK modulated signal
 end
bpsk_mod=2*data1-1;//BPSK Modulated signal

   snr=1:10;//Signal to Noise Ratio
    for k=1:1:length(snr)
        H=1/sqrt(2)*(rand(1,length(qpsk_mod),'normal')+%i*(rand(1,length(qpsk_mod),'normal')));
        noise1=1/sqrt(2)*(10^(-(k/20)))*(rand(1,length(qpsk_mod),'normal')+%i*(rand(1,length(qpsk_mod),'normal')));//White Gaussian Noise generation for QPSK
        noise=1/sqrt(2)*(10^(-(k/20)))*(rand(1,length(bpsk_mod),'normal')+%i*(rand(1,length(bpsk_mod),'normal')));//White Gaussian Noise generation for QPSK
               rec1_qpsk=qpsk_mod+noise1;//QPSK modulated signal over AWGN channel
               rec1_bpsk= bpsk_mod+noise;//BPSK modulated signal over AWGN channel
       
               rec_data_qpsk=[];rec_data_bpsk=[];
               rec1_i=real(rec1_qpsk);//Seperation of I phase and Q phase comopnent of received QPSK modulated signal
               rec1_q=imag(rec1_qpsk);
        //
        for i=1:length(rec1_i)//QPSK Demodulation: BPSK demodulation of I phase and Q phase components
            if rec1_i(i)>=0 
                 demod_out_i=1;
            else rec1_i(i)<0
                demod_out_i=0;                
            end
              if rec1_q(i)>=0 
                 demod_out_q=1;
            else rec1_q(i)<0
                demod_out_q=0;                
            end
           rec_data_qpsk=[rec_data_qpsk demod_out_i demod_out_q];//QPSK Demodulated signal
            end
         for i=1:1:length(data1)//BPSK Demodulation
            if real(rec1_bpsk(i))>=0 
                 demod_out_bpsk=1;
            else real(rec1_bpsk(i))<0
                demod_out_bpsk=0;                
            end
            rec_data_bpsk=[rec_data_bpsk demod_out_bpsk];//BPSK Demodulated signal
        end
       
        errA=0;errB=0;
    for i=1:sym
        if rec_data_qpsk(i)==data1(i)
            errA=errA;
        else
            errA=errA+1;
        end
    end
        BER_qpsk(k)=errA/sym;// BER of QPSK
       
         for i=1:sym
        if rec_data_bpsk(i)==data1(i)
            errB=errB;
        else
            errB=errB+1;
        end
    
        BER_bpsk(k)=errB/sym;//BER of BPSK
    end
    theoryBer = 0.5*erfc(sqrt(10.^(snr/10))); //Theoritical BER of BPSK & QPSK
  end
        
       // end
snr=1:1:10;
plot2d(snr,BER_bpsk,5,logflag="nl");//plot simulated BER of BPSK over AWGN channel
plot2d(snr,BER_qpsk,2,logflag="nl");//plot simulated BER of QPSK over AWGN channel
plot2d(snr,theoryBer,3,logflag="nl");//Plot theoritical BER of QPSK and BPSK over AWGN channel
mtlb_axis([0 20 10^-5 0.5]);//axis
xgrid(10);
xtitle( 'Bit Error Rate plot for BPSK & QPSK Modulation', 'SNR', 'BER') ;//title of plot


legend(['BER_sim_BPSK';'BER_sim_QPSK';'BER_Theory']);//legend
//This experiments results plot of bit error rate(BER) comparison of simulated BPSK over AWGN channel,simulated QPSK over AWGN channel and theoritical BER of BPSK and QPSK
// It will take few minutes to get plots as 100000 bits are applied as an input to get better plots
